/* dyn_base_lib.js   */

// V e r s i o n       1.1
//
//
//
// History
// =======
// 1.1  20-09-2003  Problem fixed with Autoscrolling and NS6/7
// 1.0  31-03-2003  First Release of "dyn_base_lib"
//
// ---------------------------------------------------------------------------------------------------------------------
//
// written by Luke @ trueworld (2003 by Luke) =>  http:   http://www.trueworld.ch
//                                                         E-Mail: luke@trueworld.ch
//
//
//
// all functions and variables have to begin with: - "twb_" for base_lib   
//                                                 - "twm_" for menu
//                                                 - "tww_" for window
//                                                 - "twr_" for tree
//                                                 - "twr_" for cursor
//
// exeptions: - all constants
//            - twb : variables -> DOM, IE, NS, NS6, pics_url, scrolling
//                    functions -> -
//            - twm : variables -> menu
//                    functions -> create_instance, create_menu, create_entry
//            - twr : variables -> tree
//                    functions -> create_tree, create_tree_entry



//======================================================================================================================
// browser detection
//======================================================================================================================

var DOM=false,IE=false,NS=false,NS6=false;
if(document.getElementById)DOM=true;
if(document.all&&!DOM)IE=true;
if(((navigator.appName=='Netscape')&&(navigator.appVersion.substring(0,1)==7))&&!DOM&&!IE)NS=true;
if(DOM && navigator.appName=='Netscape')NS6=true;
if(!DOM &&!IE &&!NS){
alert("This site was created for:\n\n"+
" - MS Internet Explorer 4.x\tor higher\n"+
" - Netscape 4.x\t\tor higher\n"+
" - Browsers that support DOM\n\n"+
"Your Browser unfortunately doesnt belong to this group - sorry!\n"+
"Please download an appropriate Browser from the internet to view this page...");
window.history.back();
}



//======================================================================================================================
// constants
//======================================================================================================================

var SHOW                         =(NS)?'show':'visible';
var INHERIT                      ='inherit';
var HIDE                         =(NS)?'hide':'hidden';
var NONE                         ='none';
var NULL                         ='null';
var HORIZONTAL                   ='horizontal';
var VERTICAL                     ='vertical';
var CENTER                       ='center';
var LEFT                         ='left';
var RIGHT                        ='right';
var YES                          ='yes';
var NO                           ='no';
var AUTO                         ='auto';
var WINDOWS                      ='windows';
var TRY_LEFT                     ='try_left';
var TRY_AUTO                     ='try_auto';
var TRY_RIGHT                    = 'try_right';
var CLICK                        = 'click';
var DBLCLICK                     = 'double_click';
var EXPANDED                     = 'expanded';
var COLLAPSED                    = 'collapsed';
var ACTIVATE                     = 'activate';
var DEFAULT                      = 'default';
var CROSSHAIR                    = 'crosshair';
var POINTER                      = 'pointer';
var MOVE                         = 'move';
var N_RESIZE                     = 'n-resize';
var NE_RESIZE                    = 'ne-resize';
var E_RESIZE                     = 'e-resize';
var SE_RESIZE                    = 'se-resize';
var S_RESIZE                     = 's-resize';
var SW_RESIZE                    = 'sw-resize';
var W_RESIZE                     = 'w-resize';
var NW_RESIZE                    = 'nw-resize';
var TEXT                         = 'text';
var WAIT                         = 'wait';
var HELP                         = 'help';


//======================================================================================================================
// variables
//======================================================================================================================

var twm_pics_url='';
var twr_pics_url='';
var tww_pics_url='';
var scrolling   = false;
var twm_prgid='';
var tww_prgid='';
var twr_prgid='';
var twc_prgid='';
var twb_tooltip_counter=0;
var twb_mouse_x=0;
var twb_mouse_y=0;
var twb_tooltip_x_old=0;
var twb_tooltip_y_old=0;
var twb_tooltip_interval;
var twb_icon = new Array();
var twb_first=true;


//======================================================================================================================
// create icon
//======================================================================================================================

//       twb_name   = CONSTANT, which identifies icon (type=number)
//       twb_adress = name of icon (without pics_url)   

function twb_create_icon (twb_adress, twb_pics_url) {
twb_icon_length=twb_icon.length;
twb_icon[twb_icon_length] = new Image();
twb_icon[twb_icon_length].src = (twb_pics_url)?twb_pics_url+twb_adress:twb_adress;
return twb_icon_length;
}



//======================================================================================================================
// check parameters
//======================================================================================================================

//       twb_prgid  = string, which identifies program
//       twb_proc   = string, which identifies procedure within program
//       twb_parm   = string, which identifies parameter to check
//       twb_value  = variable, which contains value or identifies parameter to check
//       twb_valid  = array, which contains all valid values or : "<number"> for numbers

function twb_check_param(twb_prgid,twb_proc,twb_parm,twb_value,twb_valid){
twb_str=twb_prgid+"\n\n";
if(twb_proc.substr(0,15)!="twm_spec")twb_str+="Error:\tinvalid parameter on "+twb_proc+"-definition\n\n";
if(twb_proc=="twm_spec1")twb_str+="Error:\tparameter not specified or invalid value!\n\tPlease specify correctly in definition-file either at instance- or menu-level!\n\n"; 
if(twb_proc=="twm_spec2")twb_str+="Error:\tparameter not specified or invalid value!\n\tPlease specify correctly in definition-file either at instance- or menu- or entry-level!\n\n"; 
twb_str+="   Parameter:\t"+twb_parm+"\n";
twb_str+="   Value:    \t"+twb_value+"\n";
twb_str+="   Allowed:  \t";
twb_flg=true;
for(var twb_i=0;twb_i<twb_valid.length;twb_i++){
if(twb_valid[twb_i]=="<number>"){
twb_str+="<number> / ";
if(isNaN(twb_value)!=true)twb_flg=false;
}else{
if(twb_valid[twb_i]=="<url>"){
twb_str+="<url> / ";
if(twb_value.indexOf(".")!=-1)twb_flg=false;
}else{
twb_str+=twb_valid[twb_i]+" / ";
if (twb_value==twb_valid[twb_i])twb_flg=false;
}}}
twb_str=twb_str.substr(0,twb_str.length-3);
if(twb_flg!=false)alert(twb_str);
}



//======================================================================================================================
// create elt (div/layer)
//======================================================================================================================

//       twb_prgid   = string, which identifies program: - "twb" for base_lib
//                                                       - "twm" for menu
//                                                       - "tww" for window
//                                                       - "twc" for cursor
//                                                       - "twr" for tree
//       twb_id      = id for element (DIV/LAYER)
//       twb_top     = number of pixels for top-property of element
//       twb_left    = number of pixels for left-property of element
//       twb_hght    = number of pixels for height-property of element
//       twb_wdth    = number of pixels for width-property of element
//       twb_bckgrnd = color-definition or picture-url for background of element
//       twb_vis     = defines visibility of element (use constant SHOW, HIDE or INHERIT)
//       twb_zindx   = defines zIndex-property of element
//       twb_curs    = defines cursor
//       twb_eltlv1  = identifies referenced object at top-level (e.g. instance)
//       twb_eltlv2  = identifies referenced object at 2nd-level (e.g. menu)
//       twb_eltlv3  = identifies referenced object at 3nd-level (e.g. entry)
//       twb_lev     = used for tree-generator object level                                    -> only twr
//       twb_entry   = used for tree-generator object entry                                    -> only twr
//       twb_evt     = used for tree-generator event (use constant CLICK, DBLCLICK, ACTIVATE)  -> only twr

function twb_elt_strt(twb_prgid,twb_id,twb_top,twb_left,twb_hght,twb_wdth,twb_bckgrnd,twb_vis,twb_zindx,twb_curs,twb_eltlv1,twb_eltlv2,twb_eltlv3,twb_lev,twb_entry,twb_evt){
var twb_dlm1=(NS)?'="':':';
var twb_dlm2=(NS)?'"':';';
var twb_str=(NS)?'<layer':'<div';
if(twb_id)twb_str+=' id="'+twb_id+'"';
if(!NS)twb_str+=' style="';
if((!NS)&&(!isNaN(twb_top)||!isNaN(twb_left)))twb_str+=' position:absolute;';
if(!isNaN(twb_top))twb_str+=' top'+twb_dlm1+twb_top+twb_dlm2;
if(!isNaN(twb_left))twb_str+=' left'+twb_dlm1+twb_left+twb_dlm2;
if(!isNaN(twb_wdth))twb_str+=' width'+twb_dlm1+twb_wdth+twb_dlm2;
if(!isNaN(twb_hght))twb_str+=' height'+twb_dlm1+twb_hght+twb_dlm2;
if(!isNaN(twb_zindx))twb_str+=' z-index'+twb_dlm1+twb_zindx+twb_dlm2;
if((!isNaN(twb_wdth))&&(!isNaN(twb_hght))){
if(NS)twb_str+=' clip'+twb_dlm1+'0,0,'+twb_wdth+','+twb_hght+twb_dlm2;
else twb_str+=' clip'+twb_dlm1+'rect(0px '+twb_wdth+'px '+twb_hght+'px 0px)'+twb_dlm2;
}
if(twb_bckgrnd != NONE){
if(NS){
if(twb_bckgrnd.indexOf(".")==-1)twb_str+=' bgColor'+twb_dlm1+twb_bckgrnd+twb_dlm2;
else twb_str+=' background'+twb_dlm1+twb_bckgrnd+twb_dlm2;
}else{
if(twb_bckgrnd.indexOf(".")==-1)twb_str+=' background'+twb_dlm1+twb_bckgrnd+twb_dlm2;
else twb_str+=' background'+twb_dlm1+'url('+twb_bckgrnd+')'+twb_dlm2;
}}
if(twb_vis)twb_str+=' visibility'+twb_dlm1+twb_vis+twb_dlm2;
if(twb_curs)twb_str+=' cursor'+twb_dlm1+twb_curs+twb_dlm2;
if(!NS)twb_str+='"';
if(twb_prgid=='twm'){
if(twb_eltlv3!=NONE){
twb_str+=' onMouseOver="';
if(menu[twb_eltlv1][twb_eltlv2][twb_eltlv3].link!=NONE)twb_str+='status=menu['+twb_eltlv1+']['+twb_eltlv2+']['+twb_eltlv3+'].link; ';
twb_str+='twm_show('+twb_eltlv1+','+twb_eltlv2+','+twb_eltlv3+'); ';
if(menu[twb_eltlv1][twb_eltlv2][twb_eltlv3].tooltip!=NONE)twb_str+='twb_tooltip_start(event,\''+menu[twb_eltlv1][twb_eltlv2][twb_eltlv3].tooltip+'\'); ';
twb_str+='"';
if((!NS)&&(menu[twb_eltlv1][twb_eltlv2][twb_eltlv3].link!=NONE)){
if(menu[twb_eltlv1][twb_eltlv2][twb_eltlv3].link.substr(0,11)=='javascript:'){
twb_str+=" onClick='twm_hide_link("+twb_eltlv1+","+twb_eltlv2+","+twb_eltlv3+");"+menu[twb_eltlv1][twb_eltlv2][twb_eltlv3].link+"'";
}else{
twb_str+=" onClick='twm_hide_link("+twb_eltlv1+","+twb_eltlv2+","+twb_eltlv3+"); twb_do_link(\"twm\","+twb_eltlv1+","+twb_eltlv2+","+twb_eltlv3+")'";
}}
}else{
twb_str+=' onMouseOver="clearTimeout(twm_timer);" onMouseOut="twb_tooltip_hide();status=\'\';twm_set_timer(-1,-1,-1);"';
}}
if(twb_prgid=='tww'){
if(!NS) {
twb_str+='"';
if(twb_id.indexOf("_win-title")!=-1){
twb_str+=' onMouseDown="tww_mov_win(\''+twb_id+'\');" onMouseUp="clearInterval(tww_int);" onClick   ="clearInterval(tww_int);"';      
}
if(twb_id.indexOf("_win-close")!=-1){
twb_id_win=twb_id.substr(0,twb_id.indexOf("_win-close"))+"_win";
twb_str+=' onClick   ="tww_hide(\''+twb_id_win+'\')"';
}}}
if(twb_prgid=='twr'){
if(twb_evt==CLICK){
if(!NS){
twb_str+=" onMouseDown='show_hide(\""+twb_eltlv1+"\",\""+twb_eltlv2+"\",\""+twb_eltlv3+"\",\""+twb_lev+"\",\""+twb_entry+"\");'";
}}
if((twb_evt==DBLCLICK)||(twb_evt==ACTIVATE)){
if(twb_evt==ACTIVATE)twb_str+=" onMouseOver='status=\""+tree[twb_eltlv1][twb_entry].link+"\"'; onMouseOut='status=\"\"';";
if(!NS){
if(tree[twb_eltlv1][twb_eltlv2][twb_eltlv3].expand==true){
twb_str+=" onDblClick='show_hide(\""+twb_eltlv1+"\",\""+twb_eltlv2+"\",\""+twb_eltlv3+"\",\""+twb_lev+"\",\""+twb_entry+"\");'";
}
twb_str+=" onClick='activate(\""+twb_eltlv1+"\",\""+twb_eltlv2+"\",\""+twb_eltlv3+"\",\""+twb_lev+"\",\""+twb_entry+"\");"
if(twb_evt==ACTIVATE)twb_str+="twb_do_link(\"twr\",\""+twb_eltlv1+"\",\""+twb_entry+"\");";
twb_str+="'";
}}}
twb_str+='>'
return(twb_str);
}
function twb_elt_end(){
var twb_str;
if(NS)twb_str='</layer>';
else
twb_str='</div>';
return(twb_str);
}



//======================================================================================================================
// get Object (div/layer)
//======================================================================================================================

//       twb_prgid   = string, which identifies program: - "twb" for base_lib
//                                                       - "twm" for menu
//                                                       - "tww" for window
//                                                       - "twc" for cursor
//                                                       - "twr" for tree
//       twb_id      = id for element (DIV/LAYER)
//       twb_eltlv1  = identifies referenced object at top-level (e.g. instance)  -> only twr
//       twb_eltlv2  = identifies referenced object at 2nd-level (e.g. menu)      -> only twr
//       twb_eltlv3  = identifies referenced object at 3nd-level (e.g. entry)     -> only twr

function twb_get_object(twb_prgid,twb_id,twb_eltlv1,twb_eltlv2,twb_eltlv3){
   if(NS){
       if((twb_prgid=='twm')||(twb_prgid=='twb')||(twb_prgid=='twc')){
           twb_id_tmp=twb_id.split("v");
           if(twb_id_tmp.length > 3){
               return(document.layers["v"+twb_id_tmp[1]+"v"+twb_id_tmp[2]].document.layers[twb_id]);
           }else{
               return(document.layers[twb_id]);
           }
       }
       if(twb_prgid=='twr'){
           twb_obj=document.layers[tree[twb_eltlv1][twb_eltlv2][twb_eltlv3].ids[0]];
           for(var twb_k=1;twb_k<tree[twb_eltlv1][twb_eltlv2][twb_eltlv3].ids.length;twb_k++) {
               twb_obj=twb_obj.document.layers[tree[twb_eltlv1][twb_eltlv2][twb_eltlv3].ids[twb_k]];
           }
           if (twb_id!=twb_obj.id) {
               return(twb_obj.document.layers[twb_id]);
           }else{
               return(twb_obj);
           }
       }
       if(twb_prgid=='tww'){
           twb_id_tmp = twb_id.split("-");       
           twb_obj = document.layers[twb_id_tmp[0]];
           twb_id_tmp2 = twb_id_tmp[0];
           for (var twb_i=1; twb_i < twb_id_tmp.length; twb_i++) {
               twb_id_tmp2 += "-"+twb_id_tmp[twb_i];
               twb_obj=twb_obj.document.layers[twb_id_tmp2];
           }
           return (twb_obj);
       }
   }
   if(DOM){
       if(twb_prgid=='tww' && twb_eltlv1==1){
           return(document.getElementById(twb_id));
       } else { 
           return(document.getElementById(twb_id).style);
       }
   }
   if(IE){
       if(twb_prgid=='tww' && twb_eltlv1==1){
           return(document.all[twb_id]);
       } else { 
           return(document.all[twb_id].style);
       }
   }
}



//======================================================================================================================
// do link
//======================================================================================================================

//       twb_prgid   = string, which identifies program: - "twb" for base_lib
//                                                       - "twm" for menu
//                                                       - "tww" for window
//                                                       - "twc" for cursor
//                                                       - "twr" for tree
//       twb_eltlv1  = identifies referenced object at top-level (e.g. instance)
//       twb_eltlv2  = identifies referenced object at 2nd-level (e.g. menu)    
//       twb_eltlv3  = identifies referenced object at 3nd-level (e.g. entry)     -> only twr

function twb_do_link(twb_prgid,twb_eltlv1,twb_eltlv2,twb_eltlv3){
if(twb_prgid=='twm'){
twb_link=menu[twb_eltlv1][twb_eltlv2][twb_eltlv3].link;
twb_trgt=(menu[twb_eltlv1][twb_eltlv2][twb_eltlv3].target!=NONE)?menu[twb_eltlv1][twb_eltlv2][twb_eltlv3].target:menu[twb_eltlv1][twb_eltlv2][0].target;
if(twb_trgt==NONE)twb_trgt=menu[twb_eltlv1][0].target;
}
if(twb_prgid=='twr'){
twb_link = tree[twb_eltlv1][twb_eltlv2].link;
twb_trgt = tree[twb_eltlv1][twb_eltlv2].target;
}
if((twb_link.length > 0)&&(twb_link!=NONE)){
if(twb_trgt=="_blank"){
open(unescape(twb_link));
}else{
if(twb_trgt=="_top"){
top.location.href=unescape(twb_link);
}else{
if(twb_trgt=="_parent"){
parent.location.href=unescape(twb_link);
}else{
if((twb_trgt.length==0)||(twb_trgt=="_self")||(twb_trgt==NONE)){
location.href=unescape(twb_link);
}else{
top.frames[twb_trgt].location.href=unescape(twb_link);
}}}}}}



//======================================================================================================================
// refresh
//======================================================================================================================


function twb_refresh(){
twb_start();
}



//======================================================================================================================
// start
//======================================================================================================================


function twb_start(){
if(twb_first==true){
if(twc_prgid!='')twc_go();
if(scrolling==true){
twb_scroll_timer=setInterval("twb_scroll_check()",500);
}
twb_first=false;}
if(twm_prgid!='')twm_reposition();
if(twr_prgid!='')twr_reposition();
if(tww_prgid!=''){
if (NS) {
for (var tw_i = 0; tw_i < tww_windows.length; tw_i++) {
twb_get_object('tww','tww_'+tww_windows[tw_i]+'_win-title').document.captureEvents(Event.MOUSEDOWN);
twb_get_object('tww','tww_'+tww_windows[tw_i]+'_win-title').document.onMouseDown=new Function('tww_mov_win("tww_'+tww_windows[tw_i]+'_win-title")');
twb_get_object('tww','tww_'+tww_windows[tw_i]+'_win-title').document.captureEvents(Event.MOUSEUP);
twb_get_object('tww','tww_'+tww_windows[tw_i]+'_win-title').document.onMouseUp=new Function('clearInterval(tww_int)');
twb_get_object('tww','tww_'+tww_windows[tw_i]+'_win-close').document.captureEvents(Event.CLICK);
twb_get_object('tww','tww_'+tww_windows[tw_i]+'_win-close').document.onClick=new Function('tww_hide("tww_'+tww_windows[tw_i]+'_win")');
}}}}



//======================================================================================================================
// tooltip
//======================================================================================================================

//       twb_my_event = placeholder for event. NOT to be filled when calling function
//       twb_item     = text (with html) to be shown as tooltip

document.writeln(twb_elt_strt('twb','twb_tooltip',10,10,NONE,NONE,'#FFFFFF',HIDE,1000)+twb_elt_end());
function twb_tooltip_start(twb_my_event,twb_item){
twb_tooltip_hide();
if(twb_item.length!=0){
if(NS){
document.layers['twb_tooltip'].document.write('<table border="f06e6e" cellpadding="0" cellspacing="0" bgColor="#000000"><tr><td><table bgColor="#ffffdd" cellpadding="2" cellspacing="1" border="0"><tr><td><font face="Arial" size="2">'+twb_item+'</font></td></tr></table></td></tr></table>');
document.layers['twb_tooltip'].document.close();
}
if(IE)document.all.twb_tooltip.innerHTML='<table border="0" cellpadding="0" cellspacing="0" bgColor="#000000"><tr><td><p style="margin:1"><table bgColor="#ffffdd" cellpadding="2" cellspacing="1" border="0"><tr><td><font face="Arial" size="2">'+twb_item+'</font></td></tr></table></p></td></tr></table>';
if(DOM)document.getElementById('twb_tooltip').innerHTML='<table border="0" cellpadding="0" cellspacing="0" bgColor="#000000"><tr><td><p style="margin:1"><table bgColor="#ffffdd" cellpadding="2" cellspacing="1" border="0"><tr><td><font face="Arial" size="2">'+twb_item+'</font></td></tr></table></p></td></tr></table>';
twb_tooltip_interval=setInterval("twb_tooltip_check()",50);
}}
function twb_tooltip_check(){
if((twb_mouse_x!=twb_tooltip_x_old)||(twb_mouse_y!=twb_tooltip_y_old)){
twb_tooltip_counter=0;
twb_tooltip_x_old=twb_mouse_x;
twb_tooltip_y_old=twb_mouse_y;
}else{
twb_tooltip_counter++;
}
if(twb_tooltip_counter >=20){
clearInterval(twb_tooltip_interval);
twb_get_object('twb','twb_tooltip').left=twb_mouse_x;
twb_get_object('twb','twb_tooltip').top=twb_mouse_y+21;
twb_get_object('twb','twb_tooltip').zIndex=1000;
twb_get_object('twb','twb_tooltip').visibility=SHOW;
}}
function twb_tooltip_hide(){
clearInterval(twb_tooltip_interval);
if(NS)document.layers['twb_tooltip'].visibility="hidden";
if(DOM)document.getElementById('twb_tooltip').style.visibility="hidden";
if(IE)document.all.twb_tooltip.style.visibility="hidden";
}



//======================================================================================================================
// coords
//======================================================================================================================

//       twb_my_event = placeholder for event. NOT to be filled when calling function

function twb_coords(twb_my_event){
if((NS)||(NS6)){
twb_mouse_x=twb_my_event.pageX;
twb_mouse_y=twb_my_event.pageY;
}else{
twb_mouse_x=window.event.clientX;
twb_mouse_y=window.event.clientY;
}}


if(NS){
document.captureEvents(Event.MOUSEMOVE);
document.onMouseMove=twb_coords;
}else{
document.onmousemove=twb_coords;
}



//======================================================================================================================
// scrolling
//======================================================================================================================


var twb_scroll_y_old1=0;
var twb_scroll_y_old2=-1;
var twb_scroll_y;
function twb_scroll_check(){
if ((NS)||(NS6))twb_scroll_y=pageYOffset;
else twb_scroll_y=document.body.scrollTop;
if(twb_scroll_y!=twb_scroll_y_old1){
if(twb_scroll_y_old2==-1){
twb_scroll_y_old2=twb_scroll_y_old1;
}}
if((twb_scroll_y==twb_scroll_y_old1)&&(twb_scroll_y_old2!=-1)){
twb_scroll_y_old2=-1;
if(twm_prgid)twm_reposition_scroll(twb_scroll_y);
if(twr_prgid)twr_reposition_scroll(twb_scroll_y);
}
twb_scroll_y_old1=twb_scroll_y;
}
var twb_scroll_timer;

