<?php
/*
**        Paginator 1.1
**        Paginacin de resultados de consultas MySql
**
**        Nombre de archivo        :
**                paginator.inc.php
**        Autor        :
**                Jorge Pinedo Rosas (jpinedo)        <jpinedo@ing.udep.edu.pe>
**                Con la colaboracin de los usuarios del foro de PHP de www.forosdelweb.com
**                Especialmente de dooky que poste el cdigo en el que se basa este script.        
**
**        Versin 1.0        30/11/2003        :        -Versin inicial.
**        Versin 1.1        12/01/2003        :        -Se agreg la propagacin de las variables que llegan al script va url ($_GET)
**                                                                  en los enlaces de navegacin por las pginas.
**                                                                -Se optimiz el conteo del total de registros utilizando el COUNT(*) de MySql.
**
**        Descripcin :
**                Devuelve el resultado de una consulta sql por pginas, as como los enlaces de navegacin respectivos.
**                Este script ha sido pensado con fines didcticos, por eso la gran cantidad de comentarios.        
**
**        Licencia : 
**                GPL con las siguientes extensiones:
**                         *Uselo con el fin que quiera (personal o lucrativo).
**                        *Si encuentra el cdigo de utilidad y lo usa, mandeme un mail si lo desea.
**                        *Si mejora el cdigo o encuentra errores, hagamelo saber al mail indicado.
**
**        Documentacin y ejemplo de uso:
**                http://depiura.webcindario.com/jpinedo/scripts/doc-paginator.php
**-----------------------------------------------------------------------------------------------------------*/
  
//Antes de incluir este script va include() se debe haber definido una variable $_pagi_sql
//que contenga una sentencia sql vlida

if(empty($_pagi_sql)){
        //Si no se defini $_pagi_sql... error!
        die("<b>Error paginacin : </b>No se ha definido la variable \$_pagi_sql");
}

if(empty($_pagi_cuantos)){
        //Si no se ha especificado la cantidad de registros por pgina
        //$_pagi_cuantos ser por defecto 20
        $_pagi_cuantos = 1000;
}

if (empty($_GET['pg'])){
        //Si no se ha hecho click a ninguna pgina especfica
        //O sea si es la primera vez que se ejecuta el script
    //$_pagi_actual es la pagina actual-->ser por defecto la primera.
        $_pagi_actual = 1;
}else{
        //Si se "pidi" una pgina especfica:
        //La pgina actual ser la que se pidi.
    $_pagi_actual = $_GET['pg'];
}

//Contamos el total de registros en la BD (para saber cuntas pginas sern)
$_pagi_sqlConta = eregi_replace("select (.*) from", "SELECT COUNT(*) FROM", $_pagi_sql);
$_pagi_result2 = mysql_query($_pagi_sqlConta) or die ("Error en la consulta de conteo de registros. Mysql dijo: <b>".mysql_error()."</b>");
$_pagi_totalReg = mysql_result($_pagi_result2,0,0);//total de registros

//Calculamos el nmero de pginas (saldr un decimal)
//con ceil() redondeamos y $_pagi_totyalPags ser el nmero total (entero) de pginas que tendremos
$_pagi_totalPags = ceil($_pagi_totalReg / $_pagi_cuantos);


//Creamos la navegacin a pginas especficas. Una lnea tipo: <<anterior 1 2 3 4 siguiente>>

//La idea es pasar tambin en los enlaces las variables hayan llegado por url.
$_pagi_enlace = $_SERVER['PHP_SELF'];

$_pagi_query_string = "?";
if(isset($_GET)){
        //Si ya se han pasado variables por url, escribimos el query string concatenando
        //los elementos del array $_GET excepto la variable $_GET['pg'] si es que existe.
        $_pagi_variables = $_GET;
        foreach($_pagi_variables as $_pagi_clave => $_pagi_valor){
                if($_pagi_clave != 'pg'){
                        $_pagi_query_string .= $_pagi_clave."=".$_pagi_valor."&";
                }
        }
}

//Aadimos el query string a la url.
$_pagi_enlace .= $_pagi_query_string;

//La variable $_pagi_navegacion contendr los enlaces a las pginas.
$_pagi_navegacion = '';

if ($_pagi_actual != 1){
        //Si no estamos en la pgina 1. Ponemos el enlace "anterior"
        $_pagi_url = $_pagi_actual - 1;//ser el nmero de pgina al que enlazamos
        $_pagi_navegacion .= "<a href='https://caja-ahorro-ch.ragasaapps.io".$_pagi_enlace."pg=".$_pagi_url."'>&laquo; Anterior</a>&nbsp;";
}

//Enlaces a nmeros de pgina:
for ($_pagi_i = 1; $_pagi_i<=$_pagi_totalPags; $_pagi_i++){//Desde pgina 1 hasta ltima pgina ($_pagi_totalPags)
    if ($_pagi_i == $_pagi_actual) {
                //Si el nmero de pgina es la actual ($_pagi_actual). Se escribe el nmero, pero sin enlace y en negrita.
        $_pagi_navegacion .= "<b>&nbsp;$_pagi_i&nbsp;</b>";
    }else{
                //Si es cualquier otro. Se escibe el enlace a dicho nmero de pgina.
        if($_pagi_i <=20 or $i > 20) {
        $_pagi_navegacion .= "<a href='https://caja-ahorro-ch.ragasaapps.io".$_pagi_enlace."pg=".$_pagi_i."'>".$_pagi_i."</a>&nbsp;";
    }                     }
}

if ($_pagi_actual < $_pagi_totalPags){
        //Si no estamos en la ltima pgina. Ponemos el enlace "Siguiente"
    $_pagi_url = $_pagi_actual + 1;//ser el nmero de pgina al que enlazamos
    $_pagi_navegacion .= "<a href='https://caja-ahorro-ch.ragasaapps.io".$_pagi_enlace."pg=".$_pagi_url."'>Siguiente &raquo;</a>";
}
//Hasta ac hemos completado la "barra de navegacin"

//Calculamos desde qu registro se mostrar en esta pgina
//Recordemos que el conteo empieza desde CERO.
$_pagi_inicial = ($_pagi_actual-1) * $_pagi_cuantos;

//Consulta SQL. Devuelve $cantidad registros empezando desde $_pagi_inicial
$_pagi_sqlLim = $_pagi_sql." LIMIT $_pagi_inicial,$_pagi_cuantos";
$_pagi_result = mysql_query($_pagi_sqlLim) or die ("Error en la consulta limitada. Mysql dijo: <b>".mysql_error()."</b>");

//A partir de aqu quedan disponibles dos variables:
//$_pagi_navegacion : que contiene los enlaces para navegar por las pginas
//$_pagi_result : que contiene el id del resultado de la consulta a la BD para los registros de la pgina actual.
?>
